﻿using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;
using System;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.CancelAppointment
{
    public class CreateResponseStep : FilterBase<CancelAppointmentStateObject>
    {
        public override void Execute(CancelAppointmentStateObject state)
        {

            if (!string.IsNullOrEmpty(state.CancelAppointmentFakeResponseType))
            {
                state.CancelAppointmentResponse = new CancelAppointmentResponseMessage
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO VVS*****",
                    ExceptionOccured = false,
                    SerializedInstance = state.SerializedCancelRequest,
                    PatVistaAppointment = VistaSchedulingUtilities.MapCancelAppointmentEcToLob(Side.Patient, state.PatEcResponse, state.PatEcRequest, state.ServiceAppointment.Id, Guid.Empty, state.PatFacility, state.PatClinic),
                    ProVistaAppointment = VistaSchedulingUtilities.MapCancelAppointmentEcToLob(Side.Provider, state.ProEcResponse, state.ProEcRequest, state.ServiceAppointment.Id, Guid.Empty, state.ProFacility, state.ProClinic)
                };
            }
            else
            {

                state.CancelAppointmentResponse = state.ExceptionOccured
                  ? new CancelAppointmentResponseMessage
                  {
                      ExceptionOccured = true,
                      ExceptionMessage = state.ExceptionMessage,
                      SerializedInstance = state.SerializedCancelRequest,
                      EcProcessingTime = state.EcProcessingTimeMs
                  }
                  : new CancelAppointmentResponseMessage
                  {
                      ExceptionMessage = string.Empty,
                      ExceptionOccured = false,
                      SerializedInstance = state.SerializedCancelRequest,
                      PatVistaAppointment = VistaSchedulingUtilities.MapCancelAppointmentEcToLob(Side.Patient, state.PatEcResponse, state.PatEcRequest, state.ServiceAppointment.Id, Guid.Empty, state.PatFacility, state.PatClinic),
                      ProVistaAppointment = VistaSchedulingUtilities.MapCancelAppointmentEcToLob(Side.Provider, state.ProEcResponse, state.ProEcRequest, state.ServiceAppointment.Id, Guid.Empty, state.ProFacility, state.ProClinic),
                      EcProcessingTime = state.EcProcessingTimeMs
                  };

            }
        }
    }
}
